/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.network.NetworkHandler;
import artifacts.network.ToggleArtifactPacket;
import artifacts.registry.ModItems;
import artifacts.registry.ModKeyMappings;
import dev.architectury.event.events.client.ClientTickEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_304;

public class ToggleKeyHandler {
    private static final Map<WearableArtifactItem, class_304> TOGGLE_KEY_MAPPINGS = new HashMap<WearableArtifactItem, class_304>();

    public static void register() {
        ToggleKeyHandler.addToggleInputHandler(ModItems.NIGHT_VISION_GOGGLES.get(), ModKeyMappings.TOGGLE_NIGHT_VISION_GOGGLES);
        ToggleKeyHandler.addToggleInputHandler(ModItems.UNIVERSAL_ATTRACTOR.get(), ModKeyMappings.TOGGLE_UNIVERSAL_ATTRACTOR);
    }

    public static class_304 getToggleKey(WearableArtifactItem item) {
        return TOGGLE_KEY_MAPPINGS.get((Object)item);
    }

    private static void addToggleInputHandler(WearableArtifactItem item, class_304 toggleKey) {
        TOGGLE_KEY_MAPPINGS.put(item, toggleKey);
        ToggleInputHandler handler = new ToggleInputHandler(item);
        ClientTickEvent.CLIENT_PRE.register(instance -> handler.onClientTick());
    }

    private static class ToggleInputHandler {
        private boolean wasToggleKeyDown;
        private final WearableArtifactItem item;

        public ToggleInputHandler(WearableArtifactItem item) {
            this.item = item;
        }

        public void onClientTick() {
            boolean isToggleKeyDown = ToggleKeyHandler.getToggleKey(this.item).method_1434();
            if (isToggleKeyDown && !this.wasToggleKeyDown) {
                NetworkHandler.CHANNEL.sendToServer((Object)new ToggleArtifactPacket(this.item));
            }
            this.wasToggleKeyDown = isToggleKeyDown;
        }
    }
}

